#!/bin/sh
set -e

retval=0

# for some reason, go.exec.LookPath() fails to obtain the path of iptables
# on the ci environment, even if $PATH is set correctly.
echo "[+] PATH: $PATH"

log="/var/log/opensnitchd.log"

if [ -f /proc/modules ]; then
    echo "[+] loaded modules:"
    cat /proc/modules
fi

if [ -f $log ]; then
    echo "[+] opensnitchd log:"
    cat $log
fi

nft list ruleset
if nft list ruleset | \
	grep -q "ct state related,new queue flags bypass to 0" ; then
    echo "[+] Interception rule (nftables): OK"
else
    echo "[!] Interception rule (nftables): Missing"
    retval=1
fi

exit $retval
