#
# GLOBAL REFERENCES
#

# see https://www.iana.org/assignments/enterprise-numbers/?q=48308
ARGEO_ENTERPRISE_NUMBER_OID=1.3.6.1.4.1.48308
# see https://www.rfc-editor.org/rfc/rfc9562
# uuidgen --sha1 --namespace 6ba7b812-9dad-11d1-80b4-00c04fd430c8 --name 1.3.6.1.4.1.48308 
ARGEO_ENTERPRISE_NUMBER_UUID=58873947-460c-59a6-a7b4-28a97def5f27

#
# VERSIONING
#
build-major=2
build-minor=1

# Third party libraries required by Argeo Build
ECJ_MAJOR=3
BNDLIB_BRANCH=7.0
SYSLOGGER_BRANCH=$(build-major).$(build-minor)

# Layer version
ifeq ($(qualifier),.next)
ifneq ($(shell which git),)
ifeq ($(shell git rev-parse --is-inside-work-tree),true)
git_commit_count=$(shell git rev-list --count $(major).$(minor).$(micro)..HEAD)
git_head_shorthash=$(shell git rev-parse --short=7 HEAD)
ifneq ($(git_commit_count),)
undefine qualifier
qualifier=.$(shell printf "%04d" $(git_commit_count))-$(git_head_shorthash)
endif
endif
endif
endif
A2_LAYER_VERSION=${major}.${minor}.${micro}$(qualifier)

# The following variables are found in the sdk.mk file which is generated by the configure script:
# SDK_SRC_BASE      the base of the source code, typically the root of the cloned git repository
# SDK_BUILD_BASE    the base of the output
# JAVA_HOME         the base of the JDK used to build
A2_OUTPUT ?= $(SDK_BUILD_BASE)/a2
JVM ?= "$(JAVA_HOME)/bin/java"
JAVADOC ?= "$(JAVA_HOME)/bin/javadoc"

# GNU defaults
prefix ?= /usr/local
datarootdir ?= $(prefix)/share
exec_prefix ?= $(prefix)
libdir ?= $(exec_prefix)/lib

A2_INSTALL_TARGET ?= $(DESTDIR)$(datarootdir)/a2

# The following variables have default values which can be overriden
# A2_BASE           the space-separated directories where already built a2 categories can be found
A2_BASE ?=$(call uniq, $(A2_OUTPUT) $(A2_INSTALL_TARGET) $(A2_NATIVE_INSTALL_TARGET) /usr/local/share/a2 /usr/local/lib/a2 /usr/share/a2 /usr/lib/a2)

# OS-specific
KNOWN_ARCHS ?= x86_64 aarch64 armv7l

MSYS_VERSION := $(if $(findstring Msys, $(shell uname -o)),$(word 1, $(subst ., ,$(shell uname -r))),0)

ifeq ($(MSYS_VERSION),0)	
TARGET_OS ?= linux
TARGET_ARCH ?= $(shell uname -m)
TARGET_LIBC ?= gnu
shlib_prefix=lib
shlib_suffix=.so
file_sep=/
file_path_sep=:
else
TARGET_OS ?= win32
TARGET_ARCH ?= $(shell uname -m)
TARGET_LIBC ?= default
shlib_prefix=
shlib_suffix=.dll
file_sep=\\
file_path_sep=;
endif

ifeq ("$(TARGET_ARCH)","aarch64")
TARGET_DEB_ARCH=arm64
else # we only support two architectures
TARGET_DEB_ARCH=amd64
endif

#TARGET_OS_CATEGORY_PREFIX=lib/$(TARGET_OS)
LOCAL_NATIVE_CATEGORY_PREFIX=$(shell uname -m)-$(TARGET_OS)-$(TARGET_LIBC)

TARGET_NATIVE_CATEGORY_PREFIX=$(TARGET_ARCH)-$(TARGET_OS)-$(TARGET_LIBC)

A2_NATIVE_OUTPUT=$(A2_OUTPUT)/lib
TARGET_NATIVE_OUTPUT=$(A2_NATIVE_OUTPUT)/$(TARGET_NATIVE_CATEGORY_PREFIX)
TARGET_NATIVE_CATEGORY=$(TARGET_NATIVE_OUTPUT)/$(A2_CATEGORY)
A2_NATIVE_INSTALL_TARGET ?= $(DESTDIR)$(libdir)/${TARGET_NATIVE_CATEGORY_PREFIX}

PORTABLE_CATEGORIES=$(filter-out lib/% os/%, $(CATEGORIES))
NATIVE_CATEGORIES=$(filter $(TARGET_NATIVE_CATEGORY_PREFIX)/%, $(CATEGORIES))
OS_CATEGORIES=$(filter os/%, $(CATEGORIES))
#OS_CATEGORIES=$(filter-out $(foreach arch, $(KNOWN_ARCHS), $(TARGET_OS_CATEGORY_PREFIX)/$(arch)/%), $(filter $(TARGET_OS_CATEGORY_PREFIX)/%, $(CATEGORIES)))

# JLINK
JLINK_HOME ?= $(JAVA_HOME)
JLINK_JMODS ?= $(JLINK_HOME)/jmods
A2_JMODS=$(TARGET_NATIVE_OUTPUT)/jmods
# Note: replacing $${MODULES// /,} is bash specific
#JLINK_MODULES ?= $(shell . $(JLINK_HOME)/release && echo $${MODULES// /,})
JLINK_MODULES ?= $(subst $(space),$(comma),$(shell . $(JLINK_HOME)/release && echo $$MODULES))
JLINK_JAVA_VERSION = $(shell . $(JLINK_HOME)/release && echo $$JAVA_VERSION)
ifeq ("$(shell . $(JLINK_HOME)/release && echo $$JVM_VARIANT)","Openj9")
JLINK_JVM_VARIANT=openj9
else
ifneq ("$(shell . $(JLINK_HOME)/release && echo $$GRAALVM_VERSION)",)
JLINK_JVM_VARIANT=graalvm
else
JLINK_JVM_VARIANT=hotspot
endif
endif
JLINK_JAVA_RELEASE = $(firstword $(subst .,$(space),$(JLINK_JAVA_VERSION)))

JMODS_BASE=$(SDK_BUILD_BASE)/jmods

define a2_jmod_bare_module
	$(RM) -r $(JMODS_BASE)/$(1)/java
	$(RM) -r $(JMODS_BASE)/$(1)/classes
	mkdir -p $(JMODS_BASE)/$(1)/java
	mkdir -p $(JMODS_BASE)/$(1)/classes
	echo "module $(1) {}" > $(JMODS_BASE)/$(1)/java/module-info.java
	$(JLINK_HOME)/bin/javac --release 11 -d $(JMODS_BASE)/$(1)/classes \
	 $(JMODS_BASE)/$(1)/java/module-info.java
endef

# Minimal required OS libs for distribution
A2_OS_LIBS_CATEGORY=org.argeo.os.libs
JMOD_OS_LIBS=$(A2_OS_LIBS_CATEGORY)

ifeq ($(MSYS_VERSION),0)
A2_OS_LIBS=\
/usr/lib/$(TARGET_NATIVE_CATEGORY_PREFIX)/ld-linux-x86-64.so.* \
/usr/lib/$(TARGET_NATIVE_CATEGORY_PREFIX)/libc.so.* \
/usr/lib/$(TARGET_NATIVE_CATEGORY_PREFIX)/libstdc++.so.* \
/usr/lib/$(TARGET_NATIVE_CATEGORY_PREFIX)/libz.so.* \
/usr/lib/$(TARGET_NATIVE_CATEGORY_PREFIX)/libm.so.* \
/usr/lib/$(TARGET_NATIVE_CATEGORY_PREFIX)/libgcc_s.so.*

# TODO make it more robust
A2_OS_LIBS_VERSION = $(shell gcc -dumpversion).0.0
else
UCRT_BASE ?= /ucrt64
A2_OS_LIBS=\
$(UCRT_BASE)/bin/libgcc_s_seh-*.dll \
$(UCRT_BASE)/bin/libgomp-*.dll \
$(UCRT_BASE)/bin/libstdc++-*.dll \
$(UCRT_BASE)/bin/libwinpthread-*.dll
A2_OS_LIBS_VERSION = $(firstword $(subst -,$(space),$(shell pacman -Q mingw-w64-ucrt-x86_64-gcc-libs | awk '{print $$2}')))
#  pacman -Q mingw-w64-ucrt-x86_64-gcc-libs | awk '{print $2}'
endif

a2-prepare-os-libs: a2-prepare-output
	mkdir -p $(TARGET_NATIVE_OUTPUT)/$(A2_OS_LIBS_CATEGORY)
	cp $(A2_OS_LIBS) $(TARGET_NATIVE_OUTPUT)/$(A2_OS_LIBS_CATEGORY)
ifeq ($(MSYS_VERSION),0)
# No need to link on Linux
else
	ln -f -r -s $(TARGET_NATIVE_OUTPUT)/$(A2_OS_LIBS_CATEGORY)/$(SHLIB_PREFIX)*$(SHLIB_SUFFIX) \
	 $(TARGET_NATIVE_OUTPUT)	
endif

jmod-os-libs: a2-prepare-os-libs
	mkdir -p $(A2_JMODS)
	mkdir -p $(JMODS_BASE)/$(JMOD_OS_LIBS)/lib
ifeq ($(MSYS_VERSION),0)
# TODO copy only when standalone
else
	$(COPY) $(TARGET_NATIVE_OUTPUT)/$(A2_OS_LIBS_CATEGORY)/$(SHLIB_PREFIX)*$(SHLIB_SUFFIX) \
	 $(JMODS_BASE)/$(JMOD_OS_LIBS)/lib
endif	
	$(call a2_jmod_bare_module,$(JMOD_OS_LIBS))
		
	$(RM) $(A2_JMODS)/$(JMOD_OS_LIBS).jmod
	$(JLINK_HOME)/bin/jmod create \
	 --module-version $(A2_OS_LIBS_VERSION) \
	 --class-path $(JMODS_BASE)/$(JMOD_OS_LIBS)/classes \
	 --libs $(JMODS_BASE)/$(JMOD_OS_LIBS)/lib \
	 $(A2_JMODS)/$(JMOD_OS_LIBS).jmod

##
## SETUP
##
a2-prepare-output: $(A2_NATIVE_OUTPUT)/local

$(A2_NATIVE_OUTPUT)/local:
	mkdir -p  $(A2_NATIVE_OUTPUT)/${LOCAL_NATIVE_CATEGORY_PREFIX}
	cd  $(A2_NATIVE_OUTPUT) && ln -s ${LOCAL_NATIVE_CATEGORY_PREFIX} local
	mkdir -p $(A2_JMODS)

##
## UTILITIES
##
# Install to a target directory without executable bit
INSTALL=install -m644 -D --target-directory
# Always try copy-on-write
COPY=cp --reflink=auto
# Recursively delete directories
RMDIR=$(RM) -r

# Reverse list
# see https://stackoverflow.com/questions/52674/simplest-way-to-reverse-the-order-of-strings-in-a-make-variable/14260762#14260762
reverse = $(if $(wordlist 2,2,$(1)),$(call reverse,$(wordlist 2,$(words $(1)),$(1))) $(firstword $(1)),$(1))

# Remove duplicates
# see https://stackoverflow.com/questions/16144115/makefile-remove-duplicate-words-without-sorting/16151140#16151140
uniq = $(if $1,$(firstword $1) $(call uniq,$(filter-out $(firstword $1),$1)))

# Make variables used to replace spaces by a separator, typically in order to generate classpaths
# for example: CLASSPATH = $(subst $(space),$(pathsep),$(strip $(JARS)))
null  :=
space := $(null) #
comma:= ,
pathsep := :
define LF

$(null)
endef
